/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.console;

import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.runtime.managers.ConsoleManager;
import pro.gravit.utils.helper.LogHelper;

public class ConsoleScene
extends AbstractScene {
    private static final long MAX_LENGTH = 16384L;
    private static final int REMOVE_LENGTH = 1024;
    private TextField commandLine;
    private TextArea output;

    public ConsoleScene(JavaFXApplication application) {
        super("scenes/console/console.fxml", application);
    }

    @Override
    protected void doInit() {
        this.output = (TextArea)LookupHelper.lookup((Node)this.layout, "#output");
        this.commandLine = (TextField)LookupHelper.lookup((Node)this.layout, "#commandInput");
        LogHelper.addOutput(this::append, (LogHelper.OutputTypes)LogHelper.OutputTypes.PLAIN);
        this.commandLine.setOnAction(this::send);
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#send")).setOnAction(this::send);
    }

    @Override
    public void reset() {
        this.output.clear();
        this.commandLine.clear();
        this.commandLine.getStyleClass().removeAll((Object[])new String[]{"InputError"});
    }

    @Override
    public String getName() {
        return "console";
    }

    private void send(ActionEvent ignored) {
        String command = this.commandLine.getText();
        this.commandLine.clear();
        try {
            ConsoleManager.handler.evalNative(command, false);
            this.commandLine.getStyleClass().removeAll((Object[])new String[]{"InputError"});
        }
        catch (Exception ex) {
            LogHelper.error((Throwable)ex);
            this.commandLine.getStyleClass().add((Object)"InputError");
        }
    }

    private void append(String text) {
        this.contextHelper.runInFxThread(() -> {
            if ((long)this.output.lengthProperty().get() > 16384L) {
                this.output.deleteText(0, 1024);
            }
            this.output.appendText(text.concat("\n"));
        });
    }
}

